<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - klever mind insurance</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="service-style.css">
    <style>
        :root {
            --primary-color: #2563eb;
            --primary-light: #3b82f6;
            --primary-dark: #1e40af;
            --secondary-color: #f59e0b;
            --light-color: #f8fafc;
            --dark-color: #1e293b;
            --gray-color: #64748b;
        }

        body {
            font-family: 'Poppins', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--dark-color);
            line-height: 1.7;
        }

        .contact-hero {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 5rem 0;
            position: relative;
            overflow: hidden;
            clip-path: polygon(0 0, 100% 0, 100% 90%, 0 100%);
            margin-bottom: -3rem;
        }

        .contact-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiPjxkZWZzPjxwYXR0ZXJuIGlkPSJwYXR0ZXJuIiB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHBhdHRlcm5Vbml0cz0idXNlclNwYWNlT25Vc2UiIHBhdHRlcm5UcmFuc2Zvcm09InJvdGF0ZSg0NSkiPjxyZWN0IHdpZHRoPSIyMCIgaGVpZ2h0PSIyMCIgZmlsbD0icmdiYSgyNTUsMjU1LDI1NSwwLjA1KSIvPjwvcGF0dGVybj48L2RlZnM+PHJlY3Qgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgZmlsbD0idXJsKCNwYXR0ZXJuKSIvPjwvc3ZnPg==');
            opacity: 0.3;
        }

        .section-title {
            position: relative;
            display: inline-block;
            margin-bottom: 2.5rem;
            font-weight: 700;
        }

        .section-title::after {
            content: '';
            position: absolute;
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
            border-radius: 2px;
        }

        .contact-card {
            border: none;
            border-radius: 12px;
            padding: 2.5rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            transition: all 0.4s ease;
            height: 100%;
            background: white;
            border-top: 4px solid var(--primary-color);
        }

        .contact-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
        }

        .contact-icon {
            font-size: 2.5rem;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            -webkit-background-clip: text;
            background-clip: text;
            -webkit-text-fill-color: transparent;
            margin-bottom: 1.5rem;
        }

        .contact-method {
            font-weight: 600;
            color: var(--primary-dark);
            margin-bottom: 0.5rem;
        }

        .contact-detail {
            color: var(--gray-color);
            margin-bottom: 1.5rem;
        }

        .contact-link {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .contact-link:hover {
            color: var(--primary-dark);
            text-decoration: underline;
        }

        .contact-form {
            background: white;
            border-radius: 12px;
            padding: 3rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        }

        .form-control,
        .form-select {
            padding: 0.75rem 1rem;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            margin-bottom: 1.5rem;
        }

        .form-control:focus,
        .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(37, 99, 235, 0.1);
        }

        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 0.75rem 2rem;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            border-radius: 8px;
        }

        .btn-primary:hover {
            background-color: var(--primary-dark);
            border-color: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(37, 99, 235, 0.3);
        }

        .map-container {
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            height: 100%;
        }

        .map-container iframe {
            width: 100%;
            height: 100%;
            min-height: 300px;
            border: none;
        }

        .working-hours {
            background: var(--light-color);
            border-radius: 12px;
            padding: 1.5rem;
            margin-top: 2rem;
        }

        .hours-list {
            list-style: none;
            padding: 0;
        }

        .hours-list li {
            display: flex;
            justify-content: space-between;
            padding: 0.5rem 0;
            border-bottom: 1px solid #e2e8f0;
        }

        .hours-list li:last-child {
            border-bottom: none;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .contact-hero {
                padding: 4rem 0;
                clip-path: polygon(0 0, 100% 0, 100% 95%, 0 100%);
                margin-bottom: -2rem;
            }

            .contact-form {
                padding: 2rem;
            }

            .section-title::after {
                bottom: -12px;
            }
        }
        /*whatapp icon*/
.whatsapp-button {
      position: fixed;
      bottom: 90px;
      right: 20px;
      background-color: #25D366;
      color: white;
      border-radius: 50%;
      width: 60px;
      height: 60px;
      display: flex;
      justify-content: center;
      align-items: center;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
      z-index: 999;
      text-decoration: none;
      font-size: 30px;
      transition: transform 0.2s;
    }

    .whatsapp-button:hover {
      transform: scale(1.1);
    }
    </style>
</head>

<body>
    <a href="enquiry.php" class="floating-enquiry-btn" title="Enquire Now">
        Enquire Here
    </a>
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <img src="image/logo.png" alt="Logo" />
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                <ul class="navbar-nav align-items-center">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="about.php">About</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="insuranceDropdown" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            Insurance
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="insuranceDropdown">
                            <li><a class="dropdown-item" href="term-life-insurance.php">Term Life Insurance</a></li>
                            <li><a class="dropdown-item" href="health-insurance.php">Health Insurance</a></li>
                            <li><a class="dropdown-item" href="investment-plan.php">Investment Plans</a></li>
                            <li><a class="dropdown-item" href="car-insurance.php">Car Insurance</a></li>
                            <li><a class="dropdown-item" href="bike-insurence.php">2 Wheeler Insurance</a></li>
                            <li><a class="dropdown-item" href="family-health-insurance.php">Family Health Insurance</a>
                            </li>
                            <li><a class="dropdown-item" href="travel-insurance.php">Travel Insurance</a></li>
                            <li><a class="dropdown-item" href="term-insurance-women.php">Term Insurance (Women)</a>
                            </li>
                            <li><a class="dropdown-item" href="term-plans-with-return-of-premium.php">Term Plans with
                                    Return of Premium</a></li>
                            <li><a class="dropdown-item" href="guaranteed-return-plan.php">Guaranteed Return Plans</a>
                            </li>
                            <li><a class="dropdown-item" href="child-savings-plan.php">Child Savings Plans</a></li>
                            <li><a class="dropdown-item" href="retirement-plan.php">Retirement Plans</a></li>
                            <li><a class="dropdown-item" href="employe-health-insurance.php">Employee Group Health
                                    Insurance</a></li>
                            <li><a class="dropdown-item" href="home-insurance.php">Home Insurance</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.php">Contact</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- Hero Section -->
    <section class="contact-hero">
        <div class="container position-relative">
            <div class="row align-items-center">
                <div class="col-lg-8 mx-auto text-center animate__animated animate__fadeIn">
                    <h1 class="display-4 fw-bold mb-4">We're Here to Help!</h1>
                    <p class="lead mb-5" style="color: #f8fafc;">Whether you have questions about our insurance plans,
                        need assistance with a
                        claim, or want personalized advice, our dedicated team at klever mind insurance is just a
                        call or click away.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Methods Section -->
    <section class="py-5" style="margin-top: 3rem;">
        <div class="container py-5">
            <div class="row mb-5">
                <div class="col-lg-8 mx-auto text-center">
                    <h2 class="section-title animate__animated animate__fadeIn">Get In Touch With Us</h2>
                </div>
            </div>

            <div class="row g-4">
                <!-- Phone -->
                <div class="col-md-6 col-lg-4 animate__animated animate__fadeInUp">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-phone-alt"></i>
                        </div>
                        <h3 class="contact-method">Customer Support Hotline</h3>
                        <p class="contact-detail">Speak directly with our insurance experts for personalized assistance.
                        </p>
                        <a href="tel:+91XXXXXXXXXX" class="contact-link">+91-XXXXXXXXXX</a>
                        <div class="working-hours">
                            <h5 class="fw-bold mb-3">Working Hours</h5>
                            <ul class="hours-list">
                                <li><span>Monday - Friday</span> <span>9:00 AM - 6:00 PM</span></li>
                                <li><span>Saturday</span> <span>10:00 AM - 4:00 PM</span></li>
                                <li><span>Sunday</span> <span>Closed</span></li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Email -->
                <div class="col-md-6 col-lg-4 animate__animated animate__fadeInUp animate__delay-1s">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <h3 class="contact-method">Email Us</h3>
                        <p class="contact-detail">Send us your queries and we'll respond within 24 hours.</p>
                        <a href="mailto:support@klevermindinsurance.com"
                            class="contact-link">support@klevermindinsurance.com</a>
                        <div class="mt-4">
                            <h5 class="fw-bold mb-3">For Business Inquiries</h5>
                            <a href="mailto:business@klevermindinsurance.com"
                                class="contact-link">business@klevermindinsurance.com</a>
                        </div>
                        <div class="d-flex mt-4" style="gap: 1rem;">
                            <a href="#" class="btn btn-outline-primary rounded-circle p-3"><i
                                    class="fab fa-facebook-f"></i></a>
                            <a href="#" class="btn btn-outline-primary rounded-circle p-3"><i
                                    class="fab fa-twitter"></i></a>
                            <a href="#" class="btn btn-outline-primary rounded-circle p-3"><i
                                    class="fab fa-linkedin-in"></i></a>
                            <a href="#" class="btn btn-outline-primary rounded-circle p-3"><i
                                    class="fab fa-instagram"></i></a>
                        </div>
                    </div>
                </div>

                <!-- Office -->
                <div class="col-md-6 col-lg-4 animate__animated animate__fadeInUp animate__delay-2s">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <h3 class="contact-method">Office Address</h3>
                        <p class="contact-detail">Visit our headquarters for in-person consultations.</p>
                        <address>
                            F44 NPL Agastya Apartments
                            590 T H Road, Tindiarpet Chennai 600081
                        </address>
                        <a href="#map" class="contact-link">View on map →</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Form Section -->
    <section class="py-5 bg-light">
        <div class="container py-5">
            <div class="row">
                <div class="col-lg-6 mb-5 mb-lg-0 animate__animated animate__fadeIn">
                    <div class="contact-form">
                        <h2 class="section-title mb-4">Send Us a Message</h2>
                        <p class="mb-4">Have specific questions? Fill out the form below and we'll get back to you
                            promptly.</p>

<form action="send_email.php" method="POST">
  <div class="row">
    <div class="col-md-6">
      <input type="text" class="form-control" name="first_name" placeholder="First Name" required>
    </div>
    <div class="col-md-6">
      <input type="text" class="form-control" name="last_name" placeholder="Last Name" required>
    </div>
  </div>

  <input type="email" class="form-control mt-3" name="email" placeholder="Email Address" required>
  <input type="tel" class="form-control mt-3" name="phone" placeholder="Phone Number">

  <!-- Replaced Dropdown Menu with Insurance Plan Options -->
  <select class="form-select mt-3" name="reason" required>
    <option value="">Please select a category</option>
    <option value="Term Life Insurance">❤️ Term Life Insurance</option>
    <option value="Investment Plans">💰 Investment Plans</option>
    <option value="Health Insurance">🏥 Health Insurance</option>
    <option value="Car Insurance">🚗 Car Insurance</option>
    <option value="2 Wheeler Insurance">🏍️ 2 Wheeler Insurance</option>
    <option value="Family Health Insurance">👨‍👩‍👧‍👦 Family Health Insurance</option>
    <option value="Travel Insurance">✈️ Travel Insurance</option>
    <option value="Term Insurance Women">👩 Term Insurance (Women)</option>
    <option value="Return of Premium Plans">🔁 Term Plans with Return of Premium</option>
    <option value="Guaranteed Return Plans">📈 Guaranteed Return Plans</option>
    <option value="Child Savings Plans">🧒 Child Savings Plans</option>
    <option value="Retirement Plans">🏖️ Retirement Plans</option>
    <option value="Employee Group Health Insurance">👥 Employee Group Health Insurance</option>
    <option value="Home Insurance">🏠 Home Insurance</option>
    <option value="Other">❓ Other</option>
  </select>

  <textarea class="form-control mt-3" name="message" rows="5" placeholder="Your Message" required></textarea>

  <button type="submit" class="btn btn-primary w-100 mt-3">Send Message</button>
</form>
                    </div>
                </div>

                <div class="col-lg-6 animate__animated animate__fadeIn animate__delay-1s">
                    <div class="map-container" id="map">
                        <!-- Replace with your actual Google Maps embed code -->
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3771.755837627606!2d72.8338643153781!3d19.05272225872684!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3be7c8df3e5048d5%3A0x4478e6d5a0e4b7a8!2sInsurance%20Plaza!5e0!3m2!1sen!2sin!4v1620000000000!5m2!1sen!2sin"
                            allowfullscreen="" loading="lazy"></iframe>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <br>
    <br>
    <!-- footer start  -->

    <div class="footer-section py-5">
        <div class="container">
            <div class="row">
                <!-- Location Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Location</h3>
                    <div class="section-divider"></div>
                    <div class="address-block">
                        F44 NPL Agastya Apartments, 590 TH Road,<br>
                        Tondiarpet, Chennai 600081
                    </div>


                    <button class="branches-btn mt-2">VIEW MORE BRANCHES</button>
                </div>

                <!-- Talk to Us Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Talk to Us</h3>
                    <div class="section-divider"></div>
                    <div class="talk-content">
                        For expert insurance advice, personalized solutions, and unmatched customer support anytime,
                        anywhere.
                    </div>
                    <a href="contact.php" class="btn talk-btnn mt-3">
                        <i class="fas fa-comments"></i>
                        TALK TO US
                    </a>
                </div>

                <!-- Useful Links Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Useful Links</h3>
                    <div class="section-divider"></div>
                    <ul class="link-list">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About Us</a></li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="footerInsuranceDropdown" role="button"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                Insurance
                            </a>
                            <ul class="dropdown-menu scrollable-footer-dropdown"
                                aria-labelledby="footerInsuranceDropdown" id="footerInsuranceMenu">
                                <li><a class="dropdown-item" href="term-life-insurance.php">Term Life Insurance</a>
                                </li>
                                <li><a class="dropdown-item" href="health-insurance.php">Health Insurance</a></li>
                                <li><a class="dropdown-item" href="investment-plan.php">Investment Plans</a></li>
                                <li><a class="dropdown-item" href="car-insurance.php">Car Insurance</a></li>
                                <li><a class="dropdown-item" href="bike-insurence.php">2 Wheeler Insurance</a></li>
                                <li><a class="dropdown-item" href="family-health-insurance.php">Family Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="travel-insurance.php">Travel Insurance</a></li>
                                <li><a class="dropdown-item" href="term-insurance-women.php">Term Insurance (Women)</a>
                                </li>
                                <li><a class="dropdown-item" href="term-plans-with-return-of-premium.php">Term Plans
                                        with Return of Premium</a></li>
                                <li><a class="dropdown-item" href="guaranteed-return-plan.php">Guaranteed Return
                                        Plans</a></li>
                                <li><a class="dropdown-item" href="child-savings-plan.php">Child Savings Plans</a></li>
                                <li><a class="dropdown-item" href="retirement-plan.php">Retirement Plans</a></li>
                                <li><a class="dropdown-item" href="employe-health-insurance.php">Employee Group Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="home-insurance.php">Home Insurance</a></li>
                            </ul>
                        </li>

                        <li><a href="contact.php">Contact Us</a></li>
                    </ul>
                </div>

                <!-- Insurance Links Section (New Fourth Column) -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Reach Us</h3>
                    <div class="section-divider"></div>
                    <!-- <ul class="link-list">
                        <li><a href="#">Term Life Insurance</a></li>
                        <li><a href="#">Health Insurance</a></li>
                        <li><a href="#">Investment Plans</a></li>
                        <li><a href="#">Terms & Conditions</a></li>
                        <li><a href="#">Get an Appointment</a></li>
                    </ul> -->
                    <div class="contact-info">
                        <i class="fas fa-phone"></i>
                        <span>+91 99406 15001</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-envelope"></i>
                        <a href="mailto:klevermindinsurance@gmail.com" class="email-link">klevermindinsurance@gmail.com</a>
                    </div>
                </div>
            </div>

            <!-- Bottom Navigation -->
            <div class="row bottom-nav mt-4">
                <div class="col-lg-6">
                    <ul class="footer-nav">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About</a></li>
                        <li><a href="terms_conditions.php">Terms and Conditions</a></li>
                    </ul>
                </div>

                <div class="col-lg-6">
                    <div class="d-flex justify-content-between align-items-center flex-column flex-lg-row">
                        <div class="copyright">
                            Copyright © 2025 Insurance. All rights reserved. Designed by <a
                                href="https://dbotdigital.com" target="_blank">Dbot Digital</a>
                        </div>

                        <!-- <div class="social-icons order-1 order-lg-2">
                            <a href="#"><i class="fab fa-facebook-f"></i></a>
                            <a href="#"><i class="fab fa-twitter"></i></a>
                            <a href="#"><i class="fab fa-google-plus-g"></i></a>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- footer end -->
<a href="https://wa.me/919940615001" class="whatsapp-button" target="_blank" title="Chat with us on WhatsApp">
        <i class="fab fa-whatsapp"></i>
    </a>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Simple animation trigger on scroll
        document.addEventListener('DOMContentLoaded', function () {
            const animateElements = document.querySelectorAll('.animate__animated');

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const animation = entry.target.getAttribute('data-animate');
                        entry.target.classList.add(animation);
                        observer.unobserve(entry.target);
                    }
                });
            }, {
                threshold: 0.1
            });

            animateElements.forEach(element => {
                observer.observe(element);
            });
        });
    </script>
</body>

</html>