<?php
$host = 'localhost';
$user = 'root';
$pass = '';
$dbname = 'schemeinsurance';

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

$result = $conn->query("SELECT * FROM insurance_cards ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Responsive Sample Page</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous" />

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="service-style.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
     body {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .showcase-card {
            border: none;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
            transition: all 0.4s ease;
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(10px);
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        .showcase-card:hover {
            transform: translateY(-15px) scale(1.02);
            box-shadow: 0 35px 70px rgba(0, 0, 0, 0.25);
        }

        .card-img-container {
            position: relative;
            overflow: hidden;
            height: 280px;
            flex-shrink: 0;
        }

        .card-img-top {
            height: 100%;
            width: 100%;
            object-fit: cover;
            transition: all 0.6s ease;
        }

        .showcase-card:hover .card-img-top {
            transform: scale(1.1);
        }

        .image-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(30, 60, 114, 0.85), rgba(42, 82, 152, 0.85));
            opacity: 0;
            transition: all 0.4s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .showcase-card:hover .image-overlay {
            opacity: 1;
        }

        .overlay-content {
            text-align: center;
            color: white;
            transform: translateY(20px);
            transition: all 0.4s ease;
        }

        .showcase-card:hover .overlay-content {
            transform: translateY(0);
        }

        .card-body {
            padding: 2rem;
            background: rgba(255, 255, 255, 0.95);
            flex: 1;
            display: flex;
            flex-direction: column;
        }

        .card-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: #1e3c72;
            margin-bottom: 1rem;
            background: linear-gradient(135deg, #1e3c72, #2a5298);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .card-text {
            color: #4a5568;
            line-height: 1.6;
            margin-bottom: 1.5rem;
            flex: 1;
        }

        .card-meta {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            font-size: 0.9rem;
            color: #718096;
            flex-wrap: wrap;
            gap: 0.5rem;
        }

        .meta-item {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .action-buttons {
            display: flex;
            gap: 1rem;
            margin-top: auto;
        }

        .btn-custom {
            border-radius: 25px;
            padding: 0.7rem 1.5rem;
            font-weight: 600;
            border: none;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            flex: 1;
        }

        .btn-primary-custom {
            background: linear-gradient(135deg, #1e3c72, #2a5298);
            color: white;
        }

        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(30, 60, 114, 0.3);
            color: white;
        }

        .btn-outline-custom {
            background: transparent;
            color: #1e3c72;
            border: 2px solid #1e3c72;
        }

        .btn-outline-custom:hover {
            background: #1e3c72;
            color: white;
            transform: translateY(-2px);
        }

        .tags {
            display: flex;
            flex-wrap: wrap;
            gap: 0.5rem;
            margin-bottom: 1rem;
        }

        .tag {
            background: linear-gradient(135deg, #1e3c72, #2a5298);
            color: white;
            padding: 0.3rem 0.8rem;
            border-radius: 15px;
            font-size: 0.8rem;
            font-weight: 500;
        }

        .premium-badge {
            position: absolute;
            top: 15px;
            right: 15px;
            background: linear-gradient(135deg, #ffd700, #ffb700);
            color: #1e3c72;
            padding: 0.4rem 0.8rem;
            border-radius: 15px;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
            box-shadow: 0 5px 15px rgba(255, 215, 0, 0.3);
            z-index: 2;
        }

        .coverage-amount {
            font-size: 1.8rem;
            font-weight: 800;
            color: #28a745;
            margin-bottom: 0.5rem;
        }

        .monthly-premium {
            font-size: 1.1rem;
            color: #1e3c72;
            font-weight: 600;
            margin-bottom: 1rem;
        }

        /* Ensure equal height columns */
        .row-equal-height {
            display: flex;
            flex-wrap: wrap;
        }

        .row-equal-height > [class*="col-"] {
            display: flex;
        }

        @media (max-width: 768px) {
            .action-buttons {
                flex-direction: column;
            }
            
            .card-meta {
                flex-direction: column;
                text-align: center;
                gap: 0.5rem;
            }

            .meta-item {
                justify-content: center;
            }

            .card-img-container {
                height: 200px;
            }
        }

        .pulse-animation {
            animation: pulse 3s infinite;
        }

        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(30, 60, 114, 0.7); }
            70% { box-shadow: 0 0 0 10px rgba(30, 60, 114, 0); }
            100% { box-shadow: 0 0 0 0 rgba(30, 60, 114, 0); }
        }

        .page-header {
            text-align: center;
            margin-bottom: 3rem;
            color: white;
        }

        .page-header h1 {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 1rem;
        }

        .page-header p {
            font-size: 1.2rem;
            opacity: 0.9;
        }

        /* Compact card styles for smaller cards */
        .compact-card .card-body {
            padding: 1.5rem;
        }

        .compact-card .card-title {
            font-size: 1.2rem;
            margin-bottom: 0.8rem;
        }

        .compact-card .coverage-amount {
            font-size: 1.4rem;
            margin-bottom: 0.3rem;
        }

        .compact-card .monthly-premium {
            font-size: 0.95rem;
            margin-bottom: 0.8rem;
        }

        .compact-card .card-text {
            font-size: 0.9rem;
            margin-bottom: 1rem;
        }
    </style>
</head>

<body>

     <a href="enquiry.html" class="floating-enquiry-btn" title="Enquire Now">
        Enquire Here
    </a>
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="#">
                <img src="image/logo.png" alt="Logo" />
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                <ul class="navbar-nav align-items-center">
                    <li class="nav-item">
                        <a class="nav-link" href="index.html">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="about.html">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="plan.html">Popular Plans</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="insuranceDropdown" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            Insurance
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="insuranceDropdown">
                            <li><a class="dropdown-item" href="term-life-insurance.html">Term Life Insurance</a></li>
                            <li><a class="dropdown-item" href="health-insurance.html">Health Insurance</a></li>
                            <li><a class="dropdown-item" href="investment-plan.html">Investment Plans</a></li>
                            <li><a class="dropdown-item" href="car-insurance.html">Car Insurance</a></li>
                            <li><a class="dropdown-item" href="bike-insurence.html">2 Wheeler Insurance</a></li>
                            <li><a class="dropdown-item" href="family-health-insurance.html">Family Health Insurance</a>
                            </li>
                            <li><a class="dropdown-item" href="travel-insurance.html">Travel Insurance</a></li>
                            <li><a class="dropdown-item" href="term-insurance-women.html">Term Insurance (Women)</a>
                            </li>
                            <li><a class="dropdown-item" href="term-plans-with-return-of-premium.html">Term Plans with
                                    Return of Premium</a></li>
                            <li><a class="dropdown-item" href="guaranteed-return-plan.html">Guaranteed Return Plans</a>
                            </li>
                            <li><a class="dropdown-item" href="child-savings-plan.html">Child Savings Plans</a></li>
                            <li><a class="dropdown-item" href="retirement-plan.html">Retirement Plans</a></li>
                            <li><a class="dropdown-item" href="employe-health-insurance.html">Employee Group Health
                                    Insurance</a></li>
                            <li><a class="dropdown-item" href="home-insurance.html">Home Insurance</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.html">Contact</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    

    <div class="container py-5">
        <div class="page-header py-5">
            <h1>Comprehensive Insurance Solutions</h1>
            <p>Protecting what matters most to you and your family</p>
        </div>

        <!-- Featured Premium Plan -->
        <div class="row justify-content-center mb-5">
            <div class="col-lg-8 col-md-10">
                <div class="card showcase-card pulse-animation">
                    <div class="premium-badge">
                        <i class="fas fa-star"></i> Premium Plan
                    </div>
                    <div class="card-img-container">
                        <img src="https://images.unsplash.com/photo-1582213782179-e0d53f98f2ca?ixlib=rb-4.0.3&auto=format&fit=crop&w=1200&q=80" 
                             class="card-img-top" alt="Happy family with umbrella - insurance protection concept">
                        <div class="image-overlay">
                            <div class="overlay-content">
                                <i class="fas fa-shield-alt fa-3x mb-2"></i>
                                <p class="mb-0">Get Protected Today</p>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <h5 class="card-title">Comprehensive Family Protection</h5>
                        
                        <div class="tags">
                            <span class="tag">Life Insurance</span>
                            <span class="tag">Health Coverage</span>
                            <span class="tag">Disability</span>
                        </div>

                        <div class="coverage-amount">₹50 Lakh Coverage</div>
                        <div class="monthly-premium">Starting from ₹2,500/month</div>
                        
                        <p class="card-text">
                            Secure your family's future with our comprehensive protection plan. Includes life insurance, critical illness coverage, and accidental death benefits all in one affordable package.
                        </p>
                        
                        <div class="card-meta">
                            <div class="meta-item">
                                <i class="fas fa-users"></i>
                                <span>Family of 4</span>
                            </div>
                            <div class="meta-item">
                                <i class="fas fa-star"></i>
                                <span>4.8/5 Rating</span>
                            </div>
                            <div class="meta-item">
                                <i class="fas fa-clock"></i>
                                <span>24/7 Support</span>
                            </div>
                        </div>
                        
                        <div class="action-buttons">
                            <a href="#" class="btn btn-primary-custom btn-custom">
                                <i class="fas fa-calculator"></i>
                                Get Quote
                            </a>
                            <a href="#" class="btn btn-outline-custom btn-custom">
                                <i class="fas fa-info-circle"></i>
                                Learn More
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Main Insurance Services -->
       
          
            
          
                  
          <div class="row">
<?php
$count = 0;
while ($row = $result->fetch_assoc()):
?>
    <div class="col-md-4 mb-4">
        <div class="card">
            <?php if ($row['image']): ?>
            <img src="<?= htmlspecialchars($row['image']) ?>" class="card-img-top" alt="Insurance Image">
            <?php endif; ?>
            <div class="card-body">
                <h5 class="card-title"><?= htmlspecialchars($row['title']) ?></h5>
                <div class="tags">
                    <span class="tag"><?= htmlspecialchars($row['tag1']) ?></span>
                    <span class="tag"><?= htmlspecialchars($row['tag2']) ?></span>
                </div>
                <div class="coverage-amount"><?= htmlspecialchars($row['coverage_amount']) ?></div>
                <div class="monthly-premium"><?= htmlspecialchars($row['monthly_premium']) ?></div>
                <p class="card-text"><?= htmlspecialchars($row['description']) ?></p>
                <div class="action-buttons">
                    <a href="#" class="btn btn-primary-custom btn-custom">
                        <i class="fas fa-plus-circle"></i> Apply Now
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php endwhile; ?>
</div>


                </div>
            </div>
            
        </div>

      
    </div>
  <div class="footer-section py-5">
        <div class="container">
            <div class="row">
                <!-- Location Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Location</h3>
                    <div class="section-divider"></div>
                    <div class="address-block">
                        F44 NPL Agastya Apartments, 590 TH Road,<br>
                        Tondiarpet, Chennai 600081
                    </div>


                    <button class="branches-btn mt-2">VIEW MORE BRANCHES</button>
                </div>

                <!-- Talk to Us Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Talk to Us</h3>
                    <div class="section-divider"></div>
                    <div class="talk-content">
                        For expert insurance advice, personalized solutions, and unmatched customer support anytime,
                        anywhere.
                    </div>
                    <a href="#" class="btn talk-btnn mt-3">
                        <i class="fas fa-comments"></i>
                        TALK TO US
                    </a>
                </div>

                <!-- Useful Links Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Useful Links</h3>
                    <div class="section-divider"></div>
                    <ul class="link-list">
                        <li><a href="index.html">Home</a></li>
                        <li><a href="about.html">About Us</a></li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="footerInsuranceDropdown" role="button"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                Insurance
                            </a>
                            <ul class="dropdown-menu scrollable-footer-dropdown"
                                aria-labelledby="footerInsuranceDropdown" id="footerInsuranceMenu">
                                <li><a class="dropdown-item" href="term-life-insurance.html">Term Life Insurance</a>
                                </li>
                                <li><a class="dropdown-item" href="health-insurance.html">Health Insurance</a></li>
                                <li><a class="dropdown-item" href="investment-plan.html">Investment Plans</a></li>
                                <li><a class="dropdown-item" href="car-insurance.html">Car Insurance</a></li>
                                <li><a class="dropdown-item" href="bike-insurence.html">2 Wheeler Insurance</a></li>
                                <li><a class="dropdown-item" href="family-health-insurance.html">Family Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="travel-insurance.html">Travel Insurance</a></li>
                                <li><a class="dropdown-item" href="term-insurance-women.html">Term Insurance (Women)</a>
                                </li>
                                <li><a class="dropdown-item" href="term-plans-with-return-of-premium.html">Term Plans
                                        with Return of Premium</a></li>
                                <li><a class="dropdown-item" href="guaranteed-return-plan.html">Guaranteed Return
                                        Plans</a></li>
                                <li><a class="dropdown-item" href="child-savings-plan.html">Child Savings Plans</a></li>
                                <li><a class="dropdown-item" href="retirement-plan.html">Retirement Plans</a></li>
                                <li><a class="dropdown-item" href="employe-health-insurance.html">Employee Group Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="home-insurance.html">Home Insurance</a></li>
                            </ul>
                        </li>

                        <li><a href="contact.html">Contact Us</a></li>
                    </ul>
                </div>

                <!-- Insurance Links Section (New Fourth Column) -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Reach Us</h3>
                    <div class="section-divider"></div>
                    <!-- <ul class="link-list">
                        <li><a href="#">Term Life Insurance</a></li>
                        <li><a href="#">Health Insurance</a></li>
                        <li><a href="#">Investment Plans</a></li>
                        <li><a href="#">Terms & Conditions</a></li>
                        <li><a href="#">Get an Appointment</a></li>
                    </ul> -->
                    <div class="contact-info">
                        <i class="fas fa-phone"></i>
                        <span>+91 99406 15001</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-envelope"></i>
                        <a href="mailto:test@testmail.com" class="email-link">test@testmail.com</a>
                    </div>
                </div>
            </div>

            <!-- Bottom Navigation -->
            <div class="row bottom-nav mt-4">
                <div class="col-lg-6">
                    <ul class="footer-nav">
                        <li><a href="index.html">Home</a></li>
                        <li><a href="about.html">About</a></li>
                        <li><a href="terms_conditions.html">Terms and Conditions</a></li>
                    </ul>
                </div>

                <div class="col-lg-6">
                    <div class="d-flex justify-content-between align-items-center flex-column flex-lg-row">
                        <div class="copyright">
                            Copyright © 2025 Insurance. All rights reserved. Designed by <a
                                href="https://dbotdigital.com" target="_blank">Dbot Digital</a>
                        </div>

                        <!-- <div class="social-icons order-1 order-lg-2">
                            <a href="#"><i class="fab fa-facebook-f"></i></a>
                            <a href="#"><i class="fab fa-twitter"></i></a>
                            <a href="#"><i class="fab fa-google-plus-g"></i></a>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script>
        // Add interactive hover effects
        document.querySelectorAll('.showcase-card').forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.style.zIndex = '10';
            });
            
            card.addEventListener('mouseleave', function() {
                this.style.zIndex = '1';
            });
        });

        // Simulate button interactions
        document.querySelectorAll('.btn-custom').forEach(btn => {
            btn.addEventListener('click', function(e) {
                e.preventDefault();
                
                // Create ripple effect
                const ripple = document.createElement('div');
                ripple.style.position = 'absolute';
                ripple.style.borderRadius = '50%';
                ripple.style.background = 'rgba(255,255,255,0.6)';
                ripple.style.transform = 'scale(0)';
                ripple.style.animation = 'ripple 0.6s linear';
                ripple.style.left = '50%';
                ripple.style.top = '50%';
                ripple.style.width = '20px';
                ripple.style.height = '20px';
                ripple.style.marginLeft = '-10px';
                ripple.style.marginTop = '-10px';
                
                this.style.position = 'relative';
                this.appendChild(ripple);
                
                setTimeout(() => {
                    ripple.remove();
                }, 600);

                // Show alert for demo
                const buttonText = this.textContent.trim();
                alert(`${buttonText} clicked! In a real application, this would redirect to the appropriate insurance application or information page.`);
            });
        });

        // Add ripple animation
        const style = document.createElement('style');
        style.textContent = `
            @keyframes ripple {
                to {
                    transform: scale(4);
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(style);

        // Add smooth scroll animations
        document.addEventListener('DOMContentLoaded', function() {
            // Animate cards on scroll
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, {
                threshold: 0.1
            });

            document.querySelectorAll('.showcase-card').forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(30px)';
                card.style.transition = `opacity 0.6s ease ${index * 0.1}s, transform 0.6s ease ${index * 0.1}s`;
                observer.observe(card);
            });
        });
    </script>
</body>
</html>