<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Responsive Sample Page</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous" />

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="service-style.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
    /*whatapp icon*/
.whatsapp-button {
      position: fixed;
      bottom: 90px;
      right: 20px;
      background-color: #25D366;
      color: white;
      border-radius: 50%;
      width: 60px;
      height: 60px;
      display: flex;
      justify-content: center;
      align-items: center;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
      z-index: 999;
      text-decoration: none;
      font-size: 30px;
      transition: transform 0.2s;
    }

    .whatsapp-button:hover {
      transform: scale(1.1);
    }
</style>
</head>

<body>
  <a href="enquiry.php" class="floating-enquiry-btn" title="Enquire Now">
        Enquire Here
    </a>
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="#">
                <img src="image/logo.png" alt="Logo" />
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                <ul class="navbar-nav align-items-center">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="about.php">About</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="insuranceDropdown" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            Insurance
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="insuranceDropdown">
                            <li><a class="dropdown-item" href="term-life-insurance.php">Term Life Insurance</a></li>
                            <li><a class="dropdown-item" href="health-insurance.php">Health Insurance</a></li>
                            <li><a class="dropdown-item" href="investment-plan.php">Investment Plans</a></li>
                            <li><a class="dropdown-item" href="car-insurance.php">Car Insurance</a></li>
                            <li><a class="dropdown-item" href="bike-insurence.php">2 Wheeler Insurance</a></li>
                            <li><a class="dropdown-item" href="family-health-insurance.php">Family Health Insurance</a>
                            </li>
                            <li><a class="dropdown-item" href="travel-insurance.php">Travel Insurance</a></li>
                            <li><a class="dropdown-item" href="term-insurance-women.php">Term Insurance (Women)</a>
                            </li>
                            <li><a class="dropdown-item" href="term-plans-with-return-of-premium.php">Term Plans with
                                    Return of Premium</a></li>
                            <li><a class="dropdown-item" href="guaranteed-return-plan.php">Guaranteed Return Plans</a>
                            </li>
                            <li><a class="dropdown-item" href="child-savings-plan.php">Child Savings Plans</a></li>
                            <li><a class="dropdown-item" href="retirement-plan.php">Retirement Plans</a></li>
                            <li><a class="dropdown-item" href="employe-health-insurance.php">Employee Group Health
                                    Insurance</a></li>
                            <li><a class="dropdown-item" href="home-insurance.php">Home Insurance</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.php">Contact</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <div class="container py-5">
        <div class="row g-4 py-5">
            <!-- Left Side Content -->
            <div class="col-12 text-white p-4">
                <h2 class="mb-3 para">Term Insurance for Women</h2>
                <p>
                    Term insurance is a vital tool for women—whether working professionals, stay-at-home moms, or
                    entrepreneurs—offering peace of mind and a dependable financial safety net for their families in
                    times of uncertainty.
                </p>
                <p> With plans specifically designed to meet women's unique needs, term insurance not only safeguards
                    finances but also empowers women to take control of their future while enjoying the present.</p>
                <h2 class="mb-3 heading">Features of Term Insurance for Women</h2>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Affordable Premiums:</strong> <span class="para">Women often benefit from
                            lower premiums due to higher life expectancy. This makes term insurance a cost-effective way
                            to ensure financial protection.</span>

                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Flexible Policy Terms:</strong> <span class="para">Choose from a range of
                            policy durations that align with your life goals, whether it’s to cover your children’s
                            education, your mortgage, or your retirement years.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Critical Illness Coverage:</strong> <span class="para">Many plans offer
                            add-on benefits for critical illnesses such as breast cancer, cervical cancer, or heart
                            disease. This ensures you’re financially covered during challenging health situations.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Payout Options: </strong> <span class="para">Opt for a lump sum payout or
                            staggered payouts, depending on your family’s financial needs in case of an unfortunate
                            event.</span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Tax Benefits:</strong> <span class="para">Premiums paid toward your term
                            insurance plan may qualify for tax deductions under current tax laws, adding another layer
                            of financial advantage.</span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Customizable Riders:</strong> <span class="para">Enhance your coverage
                            with riders like accidental death benefits, waiver of premium, or income protection to
                            create a plan that fits your life perfectly</span>

                    </li>
                </ul>
                <h2 class="mb-3 heading">Benefits of Term Insurance for Women</h2>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Financial Security for Loved Ones:</strong> <span class="para">In the
                            unfortunate event of your passing, the policy ensures that your dependents are financially
                            secure. It’s a vital way to protect your family’s future and maintain their quality of
                            life.</span>

                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Coverage for Critical Illnesses:</strong> <span class="para">Women face
                            unique health challenges. With critical illness coverage, you have the financial cushion
                            needed to focus on recovery without worrying about medical expenses.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Affordable Peace of Mind:</strong> <span class="para">The affordable nature
                            of term insurance means you can enjoy the reassurance of comprehensive coverage without
                            straining your budget.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Support for Milestone Planning: </strong> <span class="para">Whether it’s
                            funding your children’s education, paying off a loan, or saving for retirement, term
                            insurance can complement your financial planning goals.</span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Confidence in Uncertain Times:</strong> <span class="para">Life is
                            unpredictable, but term insurance ensures that you and your family are prepared for whatever
                            comes your way. This allows you to focus on living fully and fearlessly.</span>
                    </li>
                </ul>
                <h2 class="mb-3 heading">Why You Should Have Term Insurance (Woman)</h2>
                <p>As a woman, your role in your family, workplace, and community is invaluable. Here’s why term
                    insurance should be a vital part of your financial plan</p>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Empower Financial Independence:</strong> <span class="para">Term insurance
                            provides you with the confidence of knowing that you have a safety net in place. It’s a step
                            toward greater financial independence and security.</span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Protect Your Loved Ones :</strong>
                        <span class="para">
                            Whether you’re a primary earner or a caregiver, your family relies on you in countless ways.
                            Term insurance ensures that your absence doesn’t create a financial burden for them.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Plan for Life’s Uncertainties:</strong> <span class="para"> Unforeseen
                            events such as health issues or accidents can disrupt even the most well-laid plans. With
                            term insurance, you’re better equipped to handle these challenges without compromising your
                            financial goals.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Affordable and Flexible Options: </strong> <span class="para">With plans
                            designed to suit different life stages and budgets, term insurance is accessible to all
                            women, making it easier to take control of your financial future.</span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Legacy Building:</strong> <span class="para">Your term insurance policy can
                            serve as a legacy for your loved ones, ensuring that they are provided for even after you’re
                            gone.</span>
                    </li>
                </ul>

            </div>



        </div>
    </div>

    <!-- contact banner start -->
    <section class="simple-cta">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <h4>Your Trusted <em>Shield in </em><strong>Uncertain</strong> Times.</h4>

                </div>
                <div class="col-lg-7">
                    <div class="buttons">
                        <div class="green-button">
                            <a href="#">Discover More</a>
                        </div>
                        <div class="orange-button">
                            <a href="#">Contact Us</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- contact banner end -->
    <br>
    <!-- Footer start -->
    <div class="footer-section py-5">
        <div class="container">
            <div class="row">
                <!-- Location Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Location</h3>
                    <div class="section-divider"></div>
                    <div class="address-block">
                        F44 NPL Agastya Apartments, 590 TH Road,<br>
                        Tondiarpet, Chennai 600081
                    </div>


                    <button class="branches-btn mt-2">VIEW MORE BRANCHES</button>
                </div>

                <!-- Talk to Us Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Talk to Us</h3>
                    <div class="section-divider"></div>
                    <div class="talk-content">
                        For expert insurance advice, personalized solutions, and unmatched customer support anytime,
                        anywhere.
                    </div>
                    <a href="contact.php" class="btn talk-btnn mt-3">
                        <i class="fas fa-comments"></i>
                        TALK TO US
                    </a>
                </div>

                <!-- Useful Links Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Useful Links</h3>
                    <div class="section-divider"></div>
                    <ul class="link-list">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About Us</a></li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="footerInsuranceDropdown" role="button"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                Insurance
                            </a>
                            <ul class="dropdown-menu scrollable-footer-dropdown"
                                aria-labelledby="footerInsuranceDropdown" id="footerInsuranceMenu">
                                <li><a class="dropdown-item" href="term-life-insurance.php">Term Life Insurance</a>
                                </li>
                                <li><a class="dropdown-item" href="health-insurance.php">Health Insurance</a></li>
                                <li><a class="dropdown-item" href="investment-plan.php">Investment Plans</a></li>
                                <li><a class="dropdown-item" href="car-insurance.php">Car Insurance</a></li>
                                <li><a class="dropdown-item" href="bike-insurence.php">2 Wheeler Insurance</a></li>
                                <li><a class="dropdown-item" href="family-health-insurance.php">Family Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="travel-insurance.php">Travel Insurance</a></li>
                                <li><a class="dropdown-item" href="term-insurance-women.php">Term Insurance (Women)</a>
                                </li>
                                <li><a class="dropdown-item" href="term-plans-with-return-of-premium.php">Term Plans
                                        with Return of Premium</a></li>
                                <li><a class="dropdown-item" href="guaranteed-return-plan.php">Guaranteed Return
                                        Plans</a></li>
                                <li><a class="dropdown-item" href="child-savings-plan.php">Child Savings Plans</a></li>
                                <li><a class="dropdown-item" href="retirement-plan.php">Retirement Plans</a></li>
                                <li><a class="dropdown-item" href="employe-health-insurance.php">Employee Group Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="home-insurance.php">Home Insurance</a></li>
                            </ul>
                        </li>

                        <li><a href="contact.php">Contact Us</a></li>
                    </ul>
                </div>

                <!-- Insurance Links Section (New Fourth Column) -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Reach Us</h3>
                    <div class="section-divider"></div>
                    <!-- <ul class="link-list">
                        <li><a href="#">Term Life Insurance</a></li>
                        <li><a href="#">Health Insurance</a></li>
                        <li><a href="#">Investment Plans</a></li>
                        <li><a href="#">Terms & Conditions</a></li>
                        <li><a href="#">Get an Appointment</a></li>
                    </ul> -->
                    <div class="contact-info">
                        <i class="fas fa-phone"></i>
                        <span>+91 99406 15001</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-envelope"></i>
                        <a href="mailto:klevermindinsurance@gmail.com" class="email-link">klevermindinsurance@gmail.com</a>
                    </div>
                </div>
            </div>

            <!-- Bottom Navigation -->
            <div class="row bottom-nav mt-4">
                <div class="col-lg-6">
                    <ul class="footer-nav">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About</a></li>
                        <li><a href="terms_conditions.php">Terms and Conditions</a></li>
                    </ul>
                </div>

                <div class="col-lg-6">
                    <div class="d-flex justify-content-between align-items-center flex-column flex-lg-row">
                        <div class="copyright">
                            Copyright © 2025 Insurance. All rights reserved. Designed by <a
                                href="https://dbotdigital.com" target="_blank">Dbot Digital</a>
                        </div>

                        <!-- <div class="social-icons order-1 order-lg-2">
                            <a href="#"><i class="fab fa-facebook-f"></i></a>
                            <a href="#"><i class="fab fa-twitter"></i></a>
                            <a href="#"><i class="fab fa-google-plus-g"></i></a>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer end  -->
<a href="https://wa.me/919940615001" class="whatsapp-button" target="_blank" title="Chat with us on WhatsApp">
        <i class="fab fa-whatsapp"></i>
    </a>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM"
        crossorigin="anonymous"></script>

</body>

</html>