<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Responsive Sample Page</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="service-style.css">
    <style>
        /*whatapp icon*/
.whatsapp-button {
      position: fixed;
      bottom: 90px;
      right: 20px;
      background-color: #25D366;
      color: white;
      border-radius: 50%;
      width: 60px;
      height: 60px;
      display: flex;
      justify-content: center;
      align-items: center;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
      z-index: 999;
      text-decoration: none;
      font-size: 30px;
      transition: transform 0.2s;
    }

    .whatsapp-button:hover {
      transform: scale(1.1);
    }
    </style>
</head>


<body>
 <!-- Floating Enquire Here Button -->
    <a href="enquiry.php" class="floating-enquiry-btn" title="Enquire Now">
        Enquire Here
    </a>
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="#">
                <img src="image/logo.png" alt="Logo" />
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                <ul class="navbar-nav align-items-center">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="about.php">About</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="insuranceDropdown" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            Insurance
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="insuranceDropdown">
                            <li><a class="dropdown-item" href="term-life-insurance.php">Term Life Insurance</a></li>
                            <li><a class="dropdown-item" href="health-insurance.php">Health Insurance</a></li>
                            <li><a class="dropdown-item" href="investment-plan.php">Investment Plans</a></li>
                            <li><a class="dropdown-item" href="car-insurance.php">Car Insurance</a></li>
                            <li><a class="dropdown-item" href="bike-insurence.php">2 Wheeler Insurance</a></li>
                            <li><a class="dropdown-item" href="family-health-insurance.php">Family Health Insurance</a>
                            </li>
                            <li><a class="dropdown-item" href="travel-insurance.php">Travel Insurance</a></li>
                            <li><a class="dropdown-item" href="term-insurance-women.php">Term Insurance (Women)</a>
                            </li>
                            <li><a class="dropdown-item" href="term-plans-with-return-of-premium.php">Term Plans with
                                    Return of Premium</a></li>
                            <li><a class="dropdown-item" href="guaranteed-return-plan.php">Guaranteed Return Plans</a>
                            </li>
                            <li><a class="dropdown-item" href="child-savings-plan.php">Child Savings Plans</a></li>
                            <li><a class="dropdown-item" href="retirement-plan.php">Retirement Plans</a></li>
                            <li><a class="dropdown-item" href="employe-health-insurance.php">Employee Group Health
                                    Insurance</a></li>
                            <li><a class="dropdown-item" href="home-insurance.php">Home Insurance</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.php">Contact</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>


    <div class="container py-5">
        <div class="row g-4 py-5">
            <!-- Left Side Content -->
            <div class="col-12 text-white p-4">
                <h2 class="mb-3 para">What is Term Life Insurance?</h2>
                <p>
                    Term life insurance is a straightforward and affordable type of life insurance that provides
                    coverage for a specific period or term. These terms typically range from 10 to 30 years, depending
                    on your needs. If the policyholder passes away during the term, the insurer pays a death benefit to
                    the designated beneficiaries. Unlike permanent life insurance, term life insurance does not include
                    a cash value component, making it a simple and cost-effective option for protecting your loved ones.
                </p>
                <p>
                    The purpose of term life insurance is to offer financial protection during critical stages of life
                    when expenses and responsibilities are at their peak, such as raising a family, paying off a
                    mortgage, or covering education costs. It’s an essential tool for anyone looking to provide their
                    family with peace of mind and a safety net during unexpected events.
                </p>

                <h2 class="mb-3 heading">Benefits of Term Life Insurance</h2>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Affordability</strong> <span class="para">life insurance is often more
                            affordable than
                            other types of
                            life insurance because it is designed solely for coverage, without additional investment
                            features. This allows you to secure higher coverage amounts at lower premiums.</span>

                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Flexible Terms:</strong> <span class="para">
                            You can choose the length of your coverage based on your specific needs. Whether you want a
                            10-year term to cover short-term financial responsibilities or a 30-year term to protect
                            your family until your children are financially independent, term life insurance adapts to
                            your timeline.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Financial Security for Loved Ones :</strong> <span class="para">The death
                            benefit provides
                            a financial safety net for your family. This money can be used to cover funeral costs, pay
                            off debts, replace lost income, or fund future goals such as college tuition.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Simple Structure:</strong> <span class="para">Term life insurance is easy
                            to understand and manage, making it an excellent option for individuals who want
                            straightforward, no-frills coverage.</span>
                    </li>
                </ul>
                <h2 class="mb-3 para">How Term Life Insurance Works</h2>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Choose a Term Length :</strong> <span class="para">Select a coverage term
                            that aligns with your financial responsibilities. Common terms include 10, 20, and 30
                            years.</span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Determine Coverage Amount:</strong> <span class="para">
                            Decide on the death benefit amount, which should reflect your family’s financial needs,
                            including living expenses, debts, and future goals
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Pay Premiums:</strong> <span class="para"> Once your policy is active,
                            you’ll pay regular premiums to maintain coverage. Premiums can often be locked in for the
                            entire term, so you’ll know exactly what to budget.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Payout Process :</strong> <span class="para"> If you pass away during the
                            term, your beneficiaries will receive the death benefit as a lump sum, typically tax-free.
                            This money can provide critical financial support during a difficult time.</span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Policy Expiration :</strong> <span class="para"> If the term ends and you
                            are still living, the coverage expires. In many cases, you may have the option to renew the
                            policy or convert it to permanent life insurance</span>
                    </li>
                </ul>

                <h2 class="mb-3 para">Who Should Consider Term Life Insurance?</h2>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Young Families :</strong> <span class="para">If you have children, term
                            life insurance can ensure they are financially secure, even if you are no longer there to
                            provide for them. The death benefit can cover everyday expenses, childcare, and future
                            education costs.</span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Homeowners :</strong> <span class="para">
                            If you’re paying off a mortgage, a term policy can help your family keep the home by
                            covering the remaining balance.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Individuals with Dependents:</strong> <span class="para"> If you support
                            dependents, such as aging parents or a spouse who doesn’t work, term life insurance provides
                            financial security for their needs.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Business Owners :</strong> <span class="para"> Entrepreneurs and small
                            business owners can use term life insurance to ensure their business can continue operating
                            or pay off business-related debts in the event of their death.</span>
                    </li>

                </ul>


            </div>



        </div>
    </div>
    <!-- contact banner start -->
    <section class="simple-cta">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <h4>Your Trusted <em>Shield in </em><strong>Uncertain</strong> Times.</h4>

                </div>
                <div class="col-lg-7">
                    <div class="buttons">
                        <div class="green-button">
                            <a href="#">Discover More</a>
                        </div>
                        <div class="orange-button">
                            <a href="#">Contact Us</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- contact banner end -->
    <br>
    <!-- Footer start -->
    <div class="footer-section py-5">
        <div class="container">
            <div class="row">
                <!-- Location Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Location</h3>
                    <div class="section-divider"></div>
                    <div class="address-block">
                        F44 NPL Agastya Apartments, 590 TH Road,<br>
                        Tondiarpet, Chennai 600081
                    </div>


                    <button class="branches-btn mt-2">VIEW MORE BRANCHES</button>
                </div>

                <!-- Talk to Us Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Talk to Us</h3>
                    <div class="section-divider"></div>
                    <div class="talk-content">
                        For expert insurance advice, personalized solutions, and unmatched customer support anytime,
                        anywhere.
                    </div>
                    <a href="contact.php" class="btn talk-btnn mt-3">
                        <i class="fas fa-comments"></i>
                        TALK TO US
                    </a>
                </div>

                <!-- Useful Links Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Useful Links</h3>
                    <div class="section-divider"></div>
                    <ul class="link-list">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About Us</a></li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="footerInsuranceDropdown" role="button"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                Insurance
                            </a>
                            <ul class="dropdown-menu scrollable-footer-dropdown"
                                aria-labelledby="footerInsuranceDropdown" id="footerInsuranceMenu">
                                <li><a class="dropdown-item" href="term-life-insurance.php">Term Life Insurance</a>
                                </li>
                                <li><a class="dropdown-item" href="health-insurance.php">Health Insurance</a></li>
                                <li><a class="dropdown-item" href="investment-plan.php">Investment Plans</a></li>
                                <li><a class="dropdown-item" href="car-insurance.php">Car Insurance</a></li>
                                <li><a class="dropdown-item" href="bike-insurence.php">2 Wheeler Insurance</a></li>
                                <li><a class="dropdown-item" href="family-health-insurance.php">Family Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="travel-insurance.php">Travel Insurance</a></li>
                                <li><a class="dropdown-item" href="term-insurance-women.php">Term Insurance (Women)</a>
                                </li>
                                <li><a class="dropdown-item" href="term-plans-with-return-of-premium.php">Term Plans
                                        with Return of Premium</a></li>
                                <li><a class="dropdown-item" href="guaranteed-return-plan.php">Guaranteed Return
                                        Plans</a></li>
                                <li><a class="dropdown-item" href="child-savings-plan.php">Child Savings Plans</a></li>
                                <li><a class="dropdown-item" href="retirement-plan.php">Retirement Plans</a></li>
                                <li><a class="dropdown-item" href="employe-health-insurance.php">Employee Group Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="home-insurance.php">Home Insurance</a></li>
                            </ul>
                        </li>

                        <li><a href="contact.php">Contact Us</a></li>
                    </ul>
                </div>

                <!-- Insurance Links Section (New Fourth Column) -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Reach Us</h3>
                    <div class="section-divider"></div>
                    <!-- <ul class="link-list">
                        <li><a href="#">Term Life Insurance</a></li>
                        <li><a href="#">Health Insurance</a></li>
                        <li><a href="#">Investment Plans</a></li>
                        <li><a href="#">Terms & Conditions</a></li>
                        <li><a href="#">Get an Appointment</a></li>
                    </ul> -->
                    <div class="contact-info">
                        <i class="fas fa-phone"></i>
                        <span>+91 99406 15001</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-envelope"></i>
                        <a href="mailto:klevermindinsurance@gmail.com" class="email-link">klevermindinsurance@gmail.com</a>
                    </div>
                </div>
            </div>

            <!-- Bottom Navigation -->
            <div class="row bottom-nav mt-4">
                <div class="col-lg-6">
                    <ul class="footer-nav">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About</a></li>
                        <li><a href="terms_conditions.php">Terms and Conditions</a></li>
                    </ul>
                </div>

                <div class="col-lg-6">
                    <div class="d-flex justify-content-between align-items-center flex-column flex-lg-row">
                        <div class="copyright">
                            Copyright © 2025 Insurance. All rights reserved. Designed by <a
                                href="https://dbotdigital.com" target="_blank">Dbot Digital</a>
                        </div>

                        <!-- <div class="social-icons order-1 order-lg-2">
                            <a href="#"><i class="fab fa-facebook-f"></i></a>
                            <a href="#"><i class="fab fa-twitter"></i></a>
                            <a href="#"><i class="fab fa-google-plus-g"></i></a>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer end  -->
    <!-- Floating Enquiry Button -->
   
<a href="https://wa.me/919940615001" class="whatsapp-button" target="_blank" title="Chat with us on WhatsApp">
        <i class="fab fa-whatsapp"></i>
    </a>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM"
        crossorigin="anonymous"></script>
   
</body>

</html>